<?php
/**
 * OrderMetaPaymentMethodsFiltersFilters
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * OrderMetaPaymentMethodsFiltersFilters Class Doc Comment
 *
 * @category Class
 * @description This object takes details of all the filtering that has to be done for this order. Filters on card bins, card schemes, card issuing bank and card suffixes
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderMetaPaymentMethodsFiltersFilters implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderMeta_payment_methods_filters_filters';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'card_bins' => '\Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardBins',
        'card_schemes' => '\Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSchemes',
        'card_suffix' => '\Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSuffix',
        'card_issuing_bank' => '\Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardIssuingBank'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'card_bins' => null,
        'card_schemes' => null,
        'card_suffix' => null,
        'card_issuing_bank' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'card_bins' => false,
		'card_schemes' => false,
		'card_suffix' => false,
		'card_issuing_bank' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'card_bins' => 'card_bins',
        'card_schemes' => 'card_schemes',
        'card_suffix' => 'card_suffix',
        'card_issuing_bank' => 'card_issuing_bank'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'card_bins' => 'setCardBins',
        'card_schemes' => 'setCardSchemes',
        'card_suffix' => 'setCardSuffix',
        'card_issuing_bank' => 'setCardIssuingBank'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'card_bins' => 'getCardBins',
        'card_schemes' => 'getCardSchemes',
        'card_suffix' => 'getCardSuffix',
        'card_issuing_bank' => 'getCardIssuingBank'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('card_bins', $data ?? [], null);
        $this->setIfExists('card_schemes', $data ?? [], null);
        $this->setIfExists('card_suffix', $data ?? [], null);
        $this->setIfExists('card_issuing_bank', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets card_bins
     *
     * @return \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardBins|null
     */
    public function getCardBins()
    {
        return $this->container['card_bins'];
    }

    /**
     * Sets card_bins
     *
     * @param \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardBins|null $card_bins card_bins
     *
     * @return self
     */
    public function setCardBins($card_bins)
    {
        if (is_null($card_bins)) {
            throw new \InvalidArgumentException('non-nullable card_bins cannot be null');
        }
        $this->container['card_bins'] = $card_bins;

        return $this;
    }

    /**
     * Gets card_schemes
     *
     * @return \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSchemes|null
     */
    public function getCardSchemes()
    {
        return $this->container['card_schemes'];
    }

    /**
     * Sets card_schemes
     *
     * @param \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSchemes|null $card_schemes card_schemes
     *
     * @return self
     */
    public function setCardSchemes($card_schemes)
    {
        if (is_null($card_schemes)) {
            throw new \InvalidArgumentException('non-nullable card_schemes cannot be null');
        }
        $this->container['card_schemes'] = $card_schemes;

        return $this;
    }

    /**
     * Gets card_suffix
     *
     * @return \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSuffix|null
     */
    public function getCardSuffix()
    {
        return $this->container['card_suffix'];
    }

    /**
     * Sets card_suffix
     *
     * @param \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardSuffix|null $card_suffix card_suffix
     *
     * @return self
     */
    public function setCardSuffix($card_suffix)
    {
        if (is_null($card_suffix)) {
            throw new \InvalidArgumentException('non-nullable card_suffix cannot be null');
        }
        $this->container['card_suffix'] = $card_suffix;

        return $this;
    }

    /**
     * Gets card_issuing_bank
     *
     * @return \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardIssuingBank|null
     */
    public function getCardIssuingBank()
    {
        return $this->container['card_issuing_bank'];
    }

    /**
     * Sets card_issuing_bank
     *
     * @param \Cashfree\Model\OrderMetaPaymentMethodsFiltersFiltersCardIssuingBank|null $card_issuing_bank card_issuing_bank
     *
     * @return self
     */
    public function setCardIssuingBank($card_issuing_bank)
    {
        if (is_null($card_issuing_bank)) {
            throw new \InvalidArgumentException('non-nullable card_issuing_bank cannot be null');
        }
        $this->container['card_issuing_bank'] = $card_issuing_bank;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


