import { secondsInHour } from "./constants.js";

/**
 * @name hoursToSeconds
 * @category Conversion Helpers
 * @summary Convert hours to seconds.
 *
 * @description
 * Convert a number of hours to a full number of seconds.
 *
 * @param hours - The number of hours to be converted
 *
 * @returns The number of hours converted in seconds
 *
 * @example
 * // Convert 2 hours to seconds:
 * const result = hoursToSeconds(2)
 * //=> 7200
 */
export function hoursToSeconds(hours) {
  return Math.trunc(hours * secondsInHour);
}

// Fallback for modularized imports:
export default hoursToSeconds;
