<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create super admin role only in SaaS mode
        if (isSaas()) {
            $superAdminRole = Role::firstOrCreate(
                ['name' => 'superadmin', 'guard_name' => 'web'],
                ['label' => 'Super Admin', 'description' => 'Super Admin has full access to all features']
            );
            $superAdminRole->syncPermissions(Permission::all());
        }

        // Create Company role
        $companyRole = Role::firstOrCreate(
            ['name' => 'company', 'guard_name' => 'web'],
            ['label' => 'Company', 'description' => 'Company has access to manage business']
        );

        // Define company permissions
        $companyPermissions = $this->getCompanyPermissions();
        $companyRole->syncPermissions(Permission::whereIn('name', $companyPermissions)->get());
    }

    private function getCompanyPermissions(): array
    {
        $basePermissions = [
            // Core system
            'manage-dashboard',
            'view-dashboard',
            'manage-users',
            'manage-any-users',
            'create-users',
            'edit-users',
            'delete-users',
            'view-users',
            'reset-password-users',
            'toggle-status-users',
            'manage-roles',
            'manage-any-roles',
            'create-roles',
            'edit-roles',
            'delete-roles',
            'view-roles',
            'view-permissions',
            'manage-email-settings',
            'manage-brand-settings',
            'manage-webhook-settings',
            'manage-settings',
            'manage-media',
            'manage-own-media',
            'create-media',
            'edit-media',
            'delete-media',
            'view-media',
            'download-media',
            'manage-media-directories',
            'manage-any-media-directories',
            'manage-own-media-directories',
            'create-media-directories',
            'edit-media-directories',
            'delete-media-directories',
            'manage-calendar',
            'view-calendar',
            'manage-language',
            'edit-language',
            'view-language',
            'view-landing-page',

            // Organization structure
            'manage-branches',
            'manage-any-branches',
            'manage-own-branches',
            'view-branches',
            'create-branches',
            'edit-branches',
            'delete-branches',
            'toggle-status-branches',
            'manage-departments',
            'manage-any-departments',
            'manage-own-departments',
            'view-departments',
            'create-departments',
            'edit-departments',
            'delete-departments',
            'toggle-status-departments',
            'manage-designations',
            'manage-any-designations',
            'manage-own-designations',
            'view-designations',
            'create-designations',
            'edit-designations',
            'delete-designations',
            'toggle-status-designations',
            'manage-document-types',
            'manage-any-document-types',
            'manage-own-document-types',
            'view-document-types',
            'create-document-types',
            'edit-document-types',
            'delete-document-types',
            'manage-employees',
            'manage-any-employees',
            'manage-own-employees',
            'view-employees',
            'create-employees',
            'edit-employees',
            'delete-employees',

            // Employee lifecycle
            'manage-award-types',
            'manage-any-award-types',
            'manage-own-award-types',
            'view-award-types',
            'create-award-types',
            'edit-award-types',
            'delete-award-types',
            'manage-awards',
            'manage-any-awards',
            'manage-own-awards',
            'view-awards',
            'create-awards',
            'edit-awards',
            'delete-awards',
            'manage-promotions',
            'manage-any-promotions',
            'manage-own-promotions',
            'view-promotions',
            'create-promotions',
            'edit-promotions',
            'delete-promotions',
            'approve-promotions',
            'reject-promotions',
            'manage-resignations',
            'manage-any-resignations',
            'manage-own-resignations',
            'view-resignations',
            'create-resignations',
            'edit-resignations',
            'delete-resignations',
            'approve-resignations',
            'reject-resignations',
            'manage-terminations',
            'manage-any-terminations',
            'manage-own-terminations',
            'view-terminations',
            'create-terminations',
            'edit-terminations',
            'delete-terminations',
            'approve-terminations',
            'reject-terminations',
            'manage-warnings',
            'manage-any-warnings',
            'manage-own-warnings',
            'view-warnings',
            'create-warnings',
            'edit-warnings',
            'delete-warnings',
            'approve-warnings',
            'acknowledge-warnings',
            'manage-trips',
            'manage-any-trips',
            'manage-own-trips',
            'view-trips',
            'create-trips',
            'edit-trips',
            'delete-trips',
            'approve-trips',
            'manage-trip-expenses',
            'approve-trip-expenses',
            'manage-complaints',
            'manage-any-complaints',
            'manage-own-complaints',
            'view-complaints',
            'create-complaints',
            'edit-complaints',
            'delete-complaints',
            'assign-complaints',
            'resolve-complaints',
            'manage-employee-transfers',
            'manage-any-employee-transfers',
            'manage-own-employee-transfers',
            'view-employee-transfers',
            'create-employee-transfers',
            'edit-employee-transfers',
            'delete-employee-transfers',
            'approve-employee-transfers',
            'reject-employee-transfers',
            'manage-holidays',
            'manage-any-holidays',
            'manage-own-holidays',
            'view-holidays',
            'create-holidays',
            'edit-holidays',
            'delete-holidays',
            'manage-announcements',
            'manage-any-announcements',
            'manage-own-announcements',
            'view-announcements',
            'create-announcements',
            'edit-announcements',
            'delete-announcements',

            // Assets
            'manage-asset-types',
            'manage-any-asset-types',
            'manage-own-asset-types',
            'view-asset-types',
            'create-asset-types',
            'edit-asset-types',
            'delete-asset-types',
            'manage-assets',
            'manage-any-assets',
            'manage-own-assets',
            'view-assets',
            'create-assets',
            'edit-assets',
            'delete-assets',
            'assign-assets',
            'manage-asset-maintenance',

            // Training
            'manage-training-types',
            'manage-any-training-types',
            'manage-own-training-types',
            'view-training-types',
            'create-training-types',
            'edit-training-types',
            'delete-training-types',
            'manage-training-programs',
            'manage-any-training-programs',
            'manage-own-training-programs',
            'view-training-programs',
            'create-training-programs',
            'edit-training-programs',
            'delete-training-programs',
            'manage-training-sessions',
            'manage-any-training-sessions',
            'manage-own-training-sessions',
            'view-training-sessions',
            'create-training-sessions',
            'edit-training-sessions',
            'delete-training-sessions',
            'manage-attendance',
            'manage-employee-trainings',
            'manage-any-employee-trainings',
            'manage-own-employee-trainings',
            'view-employee-trainings',
            'create-employee-trainings',
            'edit-employee-trainings',
            'delete-employee-trainings',
            'assign-trainings',
            'manage-assessments',
            'record-assessment-results',

            // Performance
            'manage-performance-indicator-categories',
            'manage-any-performance-indicator-categories',
            'manage-own-performance-indicator-categories',
            'view-performance-indicator-categories',
            'create-performance-indicator-categories',
            'edit-performance-indicator-categories',
            'delete-performance-indicator-categories',
            'manage-performance-indicators',
            'manage-any-performance-indicators',
            'manage-own-performance-indicators',
            'view-performance-indicators',
            'create-performance-indicators',
            'edit-performance-indicators',
            'delete-performance-indicators',
            'manage-goal-types',
            'manage-any-goal-types',
            'manage-own-goal-types',
            'view-goal-types',
            'create-goal-types',
            'edit-goal-types',
            'delete-goal-types',
            'manage-employee-goals',
            'manage-any-employee-goals',
            'manage-own-employee-goals',
            'view-employee-goals',
            'create-employee-goals',
            'edit-employee-goals',
            'delete-employee-goals',
            'manage-review-cycles',
            'manage-any-review-cycles',
            'manage-own-review-cycles',
            'view-review-cycles',
            'create-review-cycles',
            'edit-review-cycles',
            'delete-review-cycles',
            'manage-review-templates',
            'view-review-templates',
            'create-review-templates',
            'edit-review-templates',
            'delete-review-templates',
            'manage-employee-reviews',
            'manage-any-employee-reviews',
            'manage-own-employee-reviews',
            'view-employee-reviews',
            'create-employee-reviews',
            'edit-employee-reviews',
            'delete-employee-reviews',

            // Recruitment
            'manage-job-categories',
            'manage-any-job-categories',
            'manage-own-job-categories',
            'view-job-categories',
            'create-job-categories',
            'edit-job-categories',
            'delete-job-categories',
            'manage-job-requisitions',
            'manage-any-job-requisitions',
            'manage-own-job-requisitions',
            'view-job-requisitions',
            'create-job-requisitions',
            'edit-job-requisitions',
            'delete-job-requisitions',
            'approve-job-requisitions',
            'manage-job-types',
            'manage-any-job-types',
            'manage-own-job-types',
            'view-job-types',
            'create-job-types',
            'edit-job-types',
            'delete-job-types',
            'manage-job-locations',
            'manage-any-job-locations',
            'manage-own-job-locations',
            'view-job-locations',
            'create-job-locations',
            'edit-job-locations',
            'delete-job-locations',
            'manage-job-postings',
            'manage-any-job-postings',
            'manage-own-job-postings',
            'view-job-postings',
            'create-job-postings',
            'edit-job-postings',
            'delete-job-postings',
            'publish-job-postings',
            'manage-candidate-sources',
            'manage-any-candidate-sources',
            'manage-own-candidate-sources',
            'view-candidate-sources',
            'create-candidate-sources',
            'edit-candidate-sources',
            'delete-candidate-sources',
            'manage-candidates',
            'manage-any-candidates',
            'manage-own-candidates',
            'view-candidates',
            'convert-to-employee',
            // 'create-candidates',
            'edit-candidates',
            'delete-candidates',
            'manage-interview-types',
            'manage-any-interview-types',
            'manage-own-interview-types',
            'view-interview-types',
            'create-interview-types',
            'edit-interview-types',
            'delete-interview-types',
            'manage-interview-rounds',
            'manage-any-interview-rounds',
            'manage-own-interview-rounds',
            'view-interview-rounds',
            'create-interview-rounds',
            'edit-interview-rounds',
            'delete-interview-rounds',
            'manage-interviews',
            'manage-any-interviews',
            'manage-own-interviews',
            'view-interviews',
            'create-interviews',
            'edit-interviews',
            'delete-interviews',
            'manage-interview-feedback',
            'manage-any-interview-feedback',
            'manage-own-interview-feedback',
            'view-interview-feedback',
            'create-interview-feedback',
            'edit-interview-feedback',
            'delete-interview-feedback',
            'manage-custom-questions',
            'manage-any-custom-questions',
            'manage-own-custom-questions',
            'view-custom-questions',
            'create-custom-questions',
            'edit-custom-questions',
            'delete-custom-questions',
            'manage-candidate-assessments',
            'manage-any-candidate-assessments',
            'manage-own-candidate-assessments',
            'view-candidate-assessments',
            'create-candidate-assessments',
            'edit-candidate-assessments',
            'delete-candidate-assessments',
            'manage-offer-templates',
            'manage-any-offer-templates',
            'manage-own-offer-templates',
            'view-offer-templates',
            'create-offer-templates',
            'edit-offer-templates',
            'delete-offer-templates',
            'manage-offers',
            'manage-any-offers',
            'manage-own-offers',
            'view-offers',
            'create-offers',
            'edit-offers',
            'delete-offers',
            'approve-offers',
            'manage-onboarding-checklists',
            'manage-any-onboarding-checklists',
            'manage-own-onboarding-checklists',
            'view-onboarding-checklists',
            'create-onboarding-checklists',
            'edit-onboarding-checklists',
            'delete-onboarding-checklists',
            'manage-checklist-items',
            'manage-any-checklist-items',
            'manage-own-checklist-items',
            'view-checklist-items',
            'create-checklist-items',
            'edit-checklist-items',
            'delete-checklist-items',
            'manage-candidate-onboarding',
            'manage-any-candidate-onboarding',
            'manage-own-candidate-onboarding',
            'manage-candidate-onboarding-status',
            'view-candidate-onboarding',
            'create-candidate-onboarding',
            'edit-candidate-onboarding',
            'delete-candidate-onboarding',

            // Meetings
            'manage-meeting-types',
            'manage-any-meeting-types',
            'manage-own-meeting-types',
            'view-meeting-types',
            'create-meeting-types',
            'edit-meeting-types',
            'delete-meeting-types',
            'manage-meeting-rooms',
            'manage-any-meeting-rooms',
            'manage-own-meeting-rooms',
            'view-meeting-rooms',
            'create-meeting-rooms',
            'edit-meeting-rooms',
            'delete-meeting-rooms',
            'manage-meetings',
            'manage-any-meetings',
            'manage-own-meetings',
            'view-meetings',
            'create-meetings',
            'edit-meetings',
            'delete-meetings',
            'manage-meeting-status',
            'manage-meeting-attendees',
            'manage-any-meeting-attendees',
            'manage-own-meeting-attendees',
            'view-meeting-attendees',
            'create-meeting-attendees',
            'edit-meeting-attendees',
            'delete-meeting-attendees',
            'manage-meeting-rsvp-status',
            'manage-meeting-attendance',
            'manage-meeting-minutes',
            'manage-any-meeting-minutes',
            'manage-own-meeting-minutes',
            'view-meeting-minutes',
            'create-meeting-minutes',
            'edit-meeting-minutes',
            'delete-meeting-minutes',
            'manage-action-items',
            'manage-any-action-items',
            'manage-own-action-items',
            'view-action-items',
            'create-action-items',
            'edit-action-items',
            'delete-action-items',

            // Contracts & Documents
            'manage-contract-types',
            'manage-any-contract-types',
            'manage-own-contract-types',
            'view-contract-types',
            'create-contract-types',
            'edit-contract-types',
            'delete-contract-types',
            'manage-employee-contracts',
            'manage-any-employee-contracts',
            'manage-own-employee-contracts',
            'view-employee-contracts',
            'create-employee-contracts',
            'edit-employee-contracts',
            'delete-employee-contracts',
            'approve-employee-contracts',
            'reject-employee-contracts',
            'manage-contract-renewals',
            'manage-any-contract-renewals',
            'manage-own-contract-renewals',
            'view-contract-renewals',
            'create-contract-renewals',
            'edit-contract-renewals',
            'delete-contract-renewals',
            'approve-contract-renewals',
            'reject-contract-renewals',
            'manage-contract-templates',
            'manage-any-contract-templates',
            'manage-own-contract-templates',
            'view-contract-templates',
            'create-contract-templates',
            'edit-contract-templates',
            'delete-contract-templates',
            'manage-document-categories',
            'manage-any-document-categories',
            'manage-own-document-categories',
            'view-document-categories',
            'create-document-categories',
            'edit-document-categories',
            'delete-document-categories',
            'manage-hr-documents',
            'manage-any-hr-documents',
            'manage-own-hr-documents',
            'view-hr-documents',
            'create-hr-documents',
            'edit-hr-documents',
            'delete-hr-documents',
            'manage-document-acknowledgments',
            'manage-any-document-acknowledgments',
            'manage-own-document-acknowledgments',
            'view-document-acknowledgments',
            'create-document-acknowledgments',
            'edit-document-acknowledgments',
            'delete-document-acknowledgments',
            'acknowledge-document-acknowledgments',
            'manage-document-templates',
            'manage-any-document-templates',
            'manage-own-document-templates',
            'view-document-templates',
            'create-document-templates',
            'edit-document-templates',
            'delete-document-templates',

            // Leave & Attendance
            'manage-leave-types',
            'manage-any-leave-types',
            'manage-own-leave-types',
            'view-leave-types',
            'create-leave-types',
            'edit-leave-types',
            'delete-leave-types',
            'manage-leave-policies',
            'manage-any-leave-policies',
            'manage-own-leave-policies',
            'view-leave-policies',
            'create-leave-policies',
            'edit-leave-policies',
            'delete-leave-policies',
            'manage-leave-applications',
            'manage-any-leave-applications',
            'manage-own-leave-applications',
            'view-leave-applications',
            'create-leave-applications',
            'edit-leave-applications',
            'delete-leave-applications',
            'approve-leave-applications',
            'reject-leave-applications',
            'manage-leave-balances',
            'manage-any-leave-balances',
            'manage-own-leave-balances',
            'view-leave-balances',
            'create-leave-balances',
            'edit-leave-balances',
            'delete-leave-balances',
            'adjust-leave-balances',
            'manage-shifts',
            'manage-any-shifts',
            'manage-own-shifts',
            'view-shifts',
            'create-shifts',
            'edit-shifts',
            'delete-shifts',
            'manage-attendance-policies',
            'manage-any-attendance-policies',
            'manage-own-attendance-policies',
            'view-attendance-policies',
            'create-attendance-policies',
            'edit-attendance-policies',
            'delete-attendance-policies',
            'manage-attendance-records',
            'manage-any-attendance-records',
            'manage-own-attendance-records',
            'view-attendance-records',
            'create-attendance-records',
            'edit-attendance-records',
            'delete-attendance-records',
            'clock-in-out',
            'manage-attendance-regularizations',
            'manage-any-attendance-regularizations',
            'manage-own-attendance-regularizations',
            'view-attendance-regularizations',
            'create-attendance-regularizations',
            'edit-attendance-regularizations',
            'delete-attendance-regularizations',
            'approve-attendance-regularizations',
            'reject-attendance-regularizations',
            'manage-time-entries',
            'manage-any-time-entries',
            'manage-own-time-entries',
            'view-time-entries',
            'create-time-entries',
            'edit-time-entries',
            'delete-time-entries',
            'approve-time-entries',
            'reject-time-entries',

            // Payroll
            'manage-salary-components',
            'manage-any-salary-components',
            'manage-own-salary-components',
            'view-salary-components',
            'create-salary-components',
            'edit-salary-components',
            'delete-salary-components',
            'manage-employee-salaries',
            'manage-any-employee-salaries',
            'manage-own-employee-salaries',
            'view-employee-salaries',
            'create-employee-salaries',
            'edit-employee-salaries',
            'delete-employee-salaries',
            'manage-payroll-runs',
            'manage-any-payroll-runs',
            'manage-own-payroll-runs',
            'view-payroll-runs',
            'create-payroll-runs',
            'edit-payroll-runs',
            'delete-payroll-runs',
            'process-payroll-runs',
            'manage-payslips',
            'manage-any-payslips',
            'manage-own-payslips',
            'view-payslips',
            'create-payslips',
            'download-payslips',
            'send-payslips',

            // Manage Working day
            'manage-working-days-settings',
            'update-working-days-settings',

            //Biomatric Attedance 
            'manage-biomatric-attedance-settings',
            'manage-biometric-attendance',
            'sync-biometric-attendance',
            'view-biometric-attendance',

            // Ip Restriction
            'manage-ip-restriction-settings',
            'create-ip-restriction',
            'edit-ip-restriction',
            'delete-ip-restriction',

            // career page
            'manage-career-page',
        ];

        // Add SaaS-specific permissions
        if (isSaas()) {
            $saasPermissions = [
                'manage-plans',
                'manage-plan-requests',
                'manage-plan-orders',
                'view-plan-requests',
                'view-plan-orders',
                'view-plans',
                'request-plans',
                'trial-plans',
                'subscribe-plans',
                'manage-referral',
                'manage-users-referral',
                'manage-payout-referral',
                'manage-analytics'
            ];
            $basePermissions = array_merge($basePermissions, $saasPermissions);
        } else {
            $nonSaasExtraPermissions = [
                'manage-landing-page',
                'view-landing-page',
                'edit-landing-page',
                'manage-currencies',
                'manage-any-currencies',
                'manage-own-currencies',
                'view-currencies',
                'create-currencies',
                'edit-currencies',
                'delete-currencies'
            ];
            $basePermissions = array_merge($basePermissions, $nonSaasExtraPermissions);
        }

        return $basePermissions;
    }
}
